function [figure_counter,GMF,real_F,total_days_GMF,total_days_F,t_store,Q_store,tau_is_pos] = ...
    outputs(tau_thresh, n_ranges, n_eco_func, eco_names,...
    tau_star, Q_star, matrix, start_day, end_day, julian_day, figure_counter, julian_test,...
    n_chunks, eco_func_per_chunk, units)
%This function generates the outputs graphically.

%a simple flag to check if there are negative values of tau_star
if isempty(find(tau_star < 0))
    tau_is_pos = 1;
else
    tau_is_pos = 0;
end

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This is for tau_thresh < 1
% This gets the geomorphic functionality (GMF) of each ecological function
if n_ranges > 1
    
    for i = 1:length(tau_star)
        
        %Out of range totally,
        if tau_star(i) > tau_thresh(1)
            
            for k = 1:n_eco_func
                GMF(k,i) = 0;
            end %k loop
            
        end %if
        
        %Mid ranges
        for j = 1:n_ranges-1
            
            if tau_thresh(j+1) < tau_star(i) && tau_star(i) <= tau_thresh(j)
                
                for k = 1:n_eco_func
                    GMF(k,i) = matrix(j,k);
                end %k loop
                
            end %if
            
        end %j loop
        
        %Lowest range
        j = n_ranges;
        if tau_star(i) <= tau_thresh(j)      
            
            for k = 1:n_eco_func
                GMF(k,i) = matrix(j,k);
            end %k loop
            
        end %if
        
    end %i loop
    
end %if

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Something needed here for the case of 1 range
if n_ranges == 1
    
    for i = 1:length(tau_star)        
        
        %Case for the only range
        j = 1;
        if tau_thresh(j+1) < tau_star(i) && tau_star(i) <= tau_thresh(j)
            
            for k = 1:n_eco_func
                GMF(k,i) = matrix(j,k);
            end %k loop
            
        else
            for k = 1:n_eco_func
                GMF(k,i) = 0;
            end
        end
        
    end %i loops
end %if

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Geomorphically Functional Days 1:  Plotting the geomorphically functional 
% days with dots at 1's and geomorphically non functional days with dots at 0
for m = 1:n_chunks
    
    figure(figure_counter)
    if tau_is_pos
        subplot(eco_func_per_chunk(m)+1,1,1), semilogy(julian_day,tau_star)
    else
        subplot(eco_func_per_chunk(m)+1,1,1), plot(julian_day,tau_star)
    end
    box off
    hold on
    if m > 1
        title('Geomorphically Functional Days (Continued)')
    else
        title('Geomorphically Functional Days')
    end
    ylabel('\tau^*_0')
    
    for ii = 1:length(tau_thresh)
        tau_line(ii,:) = tau_thresh(ii)*ones(1,length(julian_day));
        if tau_is_pos
            subplot(eco_func_per_chunk(m)+1,1,1), semilogy(julian_day,tau_line(ii,:),'k-')
        else
            subplot(eco_func_per_chunk(m)+1,1,1), plot(julian_day,tau_line(ii,:),'k-')
        end
        text(min(julian_day), tau_line(ii,1), [' ',num2str(tau_line(ii,1))], 'HorizontalAlignment',...
            'left','VerticalAlignment','bottom')
    end
    axis tight
    legend('\tau^*_0','\tau_{threshold}')
    
    counter = 1;
    
    for i = (1 + sum(eco_func_per_chunk(1:m-1))):sum(eco_func_per_chunk(1:m))
        
        holder = find(eco_names(i,:) ~= 32);
        holder = eco_names(i,holder(1):holder(end));
        
        %figure(figure_counter)
        subplot(eco_func_per_chunk(m)+1,1,counter+1), plot(julian_day,GMF(i,:),'b.')
        axis ([0 max(julian_day) 0 1])
        text(max(julian_day),0.5,' 1 = GF, 0 = NGF ','HorizontalAlignment',...
            'right','EdgeColor','black','LineWidth',1,'Linestyle','-')
        box off
        ylabel(char(holder))
        
        if i == sum(eco_func_per_chunk(1:m))
            xlabel('Julian Day')
        end %if
        
        counter = counter + 1;
        
    end %i loop    
    
    figure_counter = figure_counter + 1;
    
end %m loop

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Geomorphicially Functional Days 2: Plotting the geomorphically 
% functional days with dots at 1 only
for m = 1:n_chunks
    
    figure(figure_counter)
    if tau_is_pos
        subplot(eco_func_per_chunk(m)+1,1,1), semilogy(julian_day,tau_star)
    else
        subplot(eco_func_per_chunk(m)+1,1,1), plot(julian_day,tau_star)
    end
    box off
    hold on    
    if m > 1
        title('Geomorphically Functional Days (Continued)')
    else
        title('Geomorphically Functional Days')
    end
    ylabel('\tau^*_0')
    
    for ii = 1:length(tau_thresh)
        tau_line(ii,:) = tau_thresh(ii)*ones(1,length(julian_day));
        if tau_is_pos
            subplot(eco_func_per_chunk(m)+1,1,1), semilogy(julian_day,tau_line(ii,:),'k-')
        else
            subplot(eco_func_per_chunk(m)+1,1,1), plot(julian_day,tau_line(ii,:),'k-')
        end
        text(min(julian_day), tau_line(ii,1), [' ',num2str(tau_line(ii,1))], 'HorizontalAlignment',...
            'left','VerticalAlignment','bottom')
    end
    axis tight
    legend('\tau^*_0','\tau_{threshold}')
    
    counter = 1;
    
    for i = (1 + sum(eco_func_per_chunk(1:m-1))):sum(eco_func_per_chunk(1:m))
        
        holder = find(eco_names(i,:) ~= 32);
        holder = eco_names(i,holder(1):holder(end));
        
        %figure(figure_counter)
        subplot(eco_func_per_chunk(m)+1,1,counter+1), plot(julian_day,GMF(i,:),'b.')
        axis ([0 max(julian_day) 0.5 1.5])
        legend('Geomorphically Functional Days')
        box off
        ylabel(char(holder))
        
        if i == sum(eco_func_per_chunk(1:m))
            xlabel('Julian Day')
        end %if
        
        counter = counter + 1;
        
    end %i loop    
    
    figure_counter = figure_counter + 1;
    
end %m loop

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Geomorphically Functionality Bar Graph: plot the results in a bar graph
for i = 1:n_eco_func
    total_days_GMF(i) = sum(GMF(i,:));
end

figure(figure_counter)
figure_counter = figure_counter + 1;
barh(total_days_GMF), colormap(cool)

for i = 1:n_eco_func
    
    holder = find(eco_names(i,:) ~= 32);
    holder = char(eco_names(i,holder(1):holder(end)));
    
    text(2, i, [holder,' (',num2str(total_days_GMF(i)),' days)'])
    
end

text(max(total_days_GMF),min(find(total_days_GMF == min(total_days_GMF))),[...
    ' Total:  ',num2str(sum(total_days_GMF)),' '],'HorizontalAlignment',...
    'right','VerticalAlignment','top','LineStyle','-','Edgecolor','black')

title('Total Number of Geomorphically Functional Days')
ylabel('Ecological Function')
xlabel('Geomorphically Functional Days')
axis tight
box off
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Functional Days 1: Plotting the functional days with dots at 1 and non - 
% functional days with a dot at 0
for m = 1:n_chunks
    
    figure(figure_counter)
    if tau_is_pos
        subplot(eco_func_per_chunk(m)+1,1,1), semilogy(julian_day,tau_star)
    else
        subplot(eco_func_per_chunk(m)+1,1,1), plot(julian_day,tau_star)
    end    
    box off
    hold on    
    if m > 1
        title('Functional Days (Continued)')
    else
        title('Functional Days')
    end
    ylabel('\tau^*_0')
    
    for ii = 1:length(tau_thresh)
        tau_line(ii,:) = tau_thresh(ii)*ones(1,length(julian_day));
        if tau_is_pos
            subplot(eco_func_per_chunk(m)+1,1,1), semilogy(julian_day,tau_line(ii,:),'k-')
        else
            subplot(eco_func_per_chunk(m)+1,1,1), plot(julian_day,tau_line(ii,:),'k-')
        end
        text(min(julian_day), tau_line(ii,1), [' ',num2str(tau_line(ii,1))], 'HorizontalAlignment',...
            'left','VerticalAlignment','bottom')
    end
    axis tight
    legend('\tau^*_0','\tau_{threshold}')
    
    counter = 1;
    
    for i = (1 + sum(eco_func_per_chunk(1:m-1))):sum(eco_func_per_chunk(1:m))
        
        for j = 1:length(julian_test)
            
            %% condition for starting day before ending
            %% day
            if start_day(i) < end_day(i)
                if julian_test(j) < start_day(i) | julian_test(j) >= end_day(i)
                    real_F(i,j) = 0;
                else
                    real_F(i,j) = GMF(i,j);
                end %inner if
            end %outer if
            
            %% condition for a wrap around:  the
            %% starting day is later than ending day
            if start_day(i) > end_day(i)
                if julian_test(j) < end_day(i) | julian_test(j) >= start_day(i)
                    real_F(i,j) = GMF(i,j);
                else
                    real_F(i,j) = 0;
                end %inner if
            end %outer if
            
        end %j loop
        
        holder = find(eco_names(i,:) ~= 32);
        holder = eco_names(i,holder(1):holder(end));
        
        %figure(figure_counter)
        subplot(eco_func_per_chunk(m)+1,1,counter+1), plot(julian_day,real_F(i,:),'b.')
        text(max(julian_day),0.5,' 1 = F, 0 = NF ','HorizontalAlignment',...
            'right','EdgeColor','black','LineWidth',1,'Linestyle','-')
        axis([0 max(julian_day) 0 1]) 
        box off
        ylabel(char(holder))
        
        if i == sum(eco_func_per_chunk(1:m))
            xlabel('Julian Day')
        end
        
        counter = counter + 1;
        
    end %i loop
    
    figure_counter = figure_counter + 1;
    
end %m loop

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Functional Days 2:  Try without seeing the dots at 0
for m = 1:n_chunks
    
    figure(figure_counter)
    if tau_is_pos
        subplot(eco_func_per_chunk(m)+1,1,1), semilogy(julian_day,tau_star)
    else
        subplot(eco_func_per_chunk(m)+1,1,1), plot(julian_day,tau_star)
    end
    box off
    hold on
    if m > 1
        title('Functional Days (Continued)')
    else
        title('Functional Days')
    end
    ylabel('\tau^*_0')
    
    for ii = 1:length(tau_thresh)
        tau_line(ii,:) = tau_thresh(ii)*ones(1,length(julian_day));
        if tau_is_pos
            subplot(eco_func_per_chunk(m)+1,1,1), semilogy(julian_day,tau_line(ii,:),'k-')
        else
            subplot(eco_func_per_chunk(m)+1,1,1), plot(julian_day,tau_line(ii,:),'k-')
        end
        text(min(julian_day), tau_line(ii,1), [' ',num2str(tau_line(ii,1))], 'HorizontalAlignment',...
            'left','VerticalAlignment','bottom')
    end
    axis tight
    legend('\tau^*_0','\tau_{threshold}')
    
    counter = 1;
    
    for i = (1 + sum(eco_func_per_chunk(1:m-1))):sum(eco_func_per_chunk(1:m))
        
        holder = find(eco_names(i,:) ~= 32);
        holder = eco_names(i,holder(1):holder(end));
        
        %figure(figure_counter)
        subplot(eco_func_per_chunk(m)+1,1,counter+1), plot(julian_day,real_F(i,:),'b.')
        axis ([0 max(julian_day) 0.5 1.5])
        legend('Functional Days')
        box off
        ylabel(char(holder))
        
        if i == sum(eco_func_per_chunk(1:m))
            xlabel('Julian Day')
        end %if
        
        counter = counter + 1;
        
    end %i loop    
    
    figure_counter = figure_counter + 1;
    
end %m loop

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Functionality Bar Graph: plot the results in a bar graph
for i = 1:n_eco_func
    total_days_F(i) = sum(real_F(i,:));
end

figure(figure_counter)
figure_counter = figure_counter + 1;
barh(total_days_F), colormap(cool)

for i = 1:n_eco_func
    
    holder = find(eco_names(i,:) ~= 32);
    holder = char(eco_names(i,holder(1):holder(end)));
    
    text(2, i, [holder,' (',num2str(total_days_F(i)),' days)'])
    
end

text(max(total_days_F),min(find(total_days_F == min(total_days_F))),[...
    ' Total:  ',num2str(sum(total_days_F)),' '],'HorizontalAlignment',...
    'right','VerticalAlignment','top','LineStyle','-','Edgecolor','black')

title('Total Number of Functional Days')
ylabel('Ecological Function')
xlabel('Functional Days')
axis tight
box off

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Functional Flows Graphs
% Find the functional julian days for each function
Q_store = [];
t_store = [];
for m = 1:n_chunks

    counter = 1;
    
    %PE stands for plotting exists for each eco func per chunk
    PE1 = 0;
    PE2 = 0;
    PE3 = 0;
    PE4 = 0;
    %plottype=1;
    for i = (1 + sum(eco_func_per_chunk(1:m-1))):sum(eco_func_per_chunk(1:m))
        
        holder = find(eco_names(i,:) ~= 32);
        holder = char(eco_names(i,holder(1):holder(end)));
        
        if counter == 1
            leg1 = ['Functional for ',holder];
        elseif counter == 2
            leg2 = ['Functional for ',holder];
        elseif counter == 3
            leg3 = ['Functional for ',holder];
        else
            leg4 = ['Functional for ',holder];
        end

        JDF = find(real_F(i,:) == 1);

        if ~isempty(JDF)
            
            % case of counter = 1
            if counter==1

                for j = 1:length(JDF)
                    Q_Func(j) = Q_star(JDF(j));
                    t_Func(j) = tau_star(JDF(j));
                end % j loop
                
                Q_store = [Q_store, Q_Func];
                t_store = [t_store, t_Func];
                
                figure(figure_counter)
                if tau_is_pos
                    loglog(Q_Func,t_Func,'c.')
                else
                    plot(Q_Func,t_Func,'c.')
                end
                hold on

                clear Q_Func t_Func
                
                PE1 = 1;

            % case of counter = 2
            elseif counter==2
                for j = 1:length(JDF)
                    Q_Func(j) = Q_star(JDF(j));
                    t_Func(j) = tau_star(JDF(j));
                end % j loop
                
                Q_store = [Q_store, Q_Func];
                t_store = [t_store, t_Func];

                figure(figure_counter)
                if tau_is_pos
                    loglog(Q_Func,t_Func,'g.')
                else
                    plot(Q_Func,t_Func,'g.')
                end
                hold on

                clear Q_Func t_Func
                
                PE2 = 1;

            % case of counter = 3
            elseif counter==3

                for j = 1:length(JDF)
                    Q_Func(j) = Q_star(JDF(j));
                    t_Func(j) = tau_star(JDF(j));
                end % j loop
                
                Q_store = [Q_store, Q_Func];
                t_store = [t_store, t_Func];
                
                figure(figure_counter)
                if tau_is_pos
                    loglog(Q_Func,t_Func,'b.')
                else
                    plot(Q_Func,t_Func,'b.')
                end
                hold on

                clear Q_Func t_Func
                
                PE3 = 1;

            % case of counter = 4
            else

                for j = 1:length(JDF)
                    Q_Func(j) = Q_star(JDF(j));
                    t_Func(j) = tau_star(JDF(j));
                end % j loop
                
                Q_store = [Q_store, Q_Func];
                t_store = [t_store, t_Func];

                figure(figure_counter)
                if tau_is_pos
                    loglog(Q_Func,t_Func,'r.')
                else
                    loglog(Q_Func,t_Func,'r.')
                end
                hold on

                clear Q_Func t_Func
                
                PE4 = 1;

            end %large counter if statement

        end %larger not isempty(JDF) check

        counter = counter + 1;

    end % i loop
    
    figure(figure_counter)
    for i = 1:length(tau_thresh)
        tau_line(i,:) = tau_thresh(i)*ones(1,length(Q_star));
        if tau_is_pos
            loglog(Q_star,tau_line(i,:),'k-')
        else
            plot(Q_star,tau_line(i,:),'k-')
        end
        text(min(Q_star), tau_line(i,1), [' ',num2str(tau_line(i,1))], 'HorizontalAlignment',...
            'left','VerticalAlignment','bottom')
    end
    
    %cumbersome legend if statements
    %case of just 1 existing
    if PE1 && ~PE2 && ~PE3 && ~PE4
        legend(leg1,'\tau_{threshold}','Location','SouthEast')
    elseif ~PE1 &&  PE2 && ~PE3 && ~PE4
        legend(leg2,'\tau_{threshold}','Location','SouthEast')
    elseif ~PE1 && ~PE2 &&  PE3 && ~PE4
        legend(leg3,'\tau_{threshold}','Location','SouthEast')
    elseif ~PE1 && ~PE2 && ~PE3 &&  PE4
        legend(leg4,'\tau_{threshold}','Location','SouthEast')
    %case of 2 existing
    elseif  PE1 &&  PE2 && ~PE3 && ~PE4
        legend(leg1,leg2,'\tau_{threshold}','Location','SouthEast')
    elseif  PE1 && ~PE2 &&  PE3 && ~PE4
        legend(leg1,leg3,'\tau_{threshold}','Location','SouthEast')
    elseif  PE1 && ~PE2 && ~PE3 && PE4
        legend(leg1,leg4,'\tau_{threshold}','Location','SouthEast')
    elseif ~PE1 &&  PE2 &&  PE3 && ~PE4
        legend(leg2,leg3,'\tau_{threshold}','Location','SouthEast')
    elseif ~PE1 &&  PE2 && ~PE3 && PE4
        legend(leg2,leg4,'\tau_{threshold}','Location','SouthEast')
    elseif ~PE1 && ~PE2 &&  PE3 &&  PE4
        legend(leg3,leg4,'\tau_{threshold}','Location','SouthEast')
    %case of 3 existing
    elseif ~PE1 &&  PE2 &&  PE3 &&  PE4
        legend(leg2,leg3,leg4,'\tau_{threshold}','Location','SouthEast')
    elseif  PE1 && ~PE2 &&  PE3 &&  PE4
        legend(leg1,leg3,leg4,'\tau_{threshold}','Location','SouthEast')
    elseif  PE1 &&  PE2 && ~PE3 &&  PE4
        legend(leg1,leg2,leg4,'\tau_{threshold}','Location','SouthEast')
    elseif  PE1 &&  PE2 &&  PE3 && ~PE4
        legend(leg1,leg2,leg3,'\tau_{threshold}','Location','SouthEast')
    %case of all 4 existing
    elseif  PE1 &&  PE2 &&  PE3 &&  PE4
        legend(leg1,leg2,leg3,leg4,'\tau_{threshold}','Location','SouthEast')
    %if nothing exists
    else
        legend('\tau_{threshold}')
    end
    
    title('\tau^*_0 vs. Q^* for Functional Days')
    xlabel('Q^*')
    ylabel('\tau^*_0')
    
    axis tight
    box off
    
    figure_counter = figure_counter + 1;
    
end %m loop

%Actual low and high ranges for each shear range
disp(' ')
disp('<< Actual Functional Flow Ranges >>')
for i = 1:n_ranges
    if i < n_ranges
        
        Q_range = find(t_store <= tau_thresh(i));
        Q_range = find(t_store(Q_range) > tau_thresh(i+1));
        
        if isempty(Q_range)            
            fprintf('For %g < T < %g, there are no actual functional flows.',...
                tau_thresh(i+1),tau_thresh(i))
            fprintf('\n')
            fprintf('\n')
            continue
        end
        
        fprintf('For %g < T < %g, the actual functional flow range is %g < Q* < %g.',...
            tau_thresh(i+1),tau_thresh(i),min(Q_store(Q_range)),max(Q_store(Q_range)))
        fprintf('\n')
        fprintf('\n')
        clear Q_range

    else
        
        Q_range = find(t_store <= tau_thresh(i));
        
        if isempty(Q_range)
            fprintf('For T < %g, there are no actual functional flows.',...
                tau_thresh(i))
            fprintf('\n')
            fprintf('\n')
            continue
        end
           
        fprintf('For T < %g, the actual functional flow range is %g < Q* < %g.',...
            tau_thresh(i),min(Q_store(Q_range)),max(Q_store(Q_range)))
        fprintf('\n')
        fprintf('\n')
        
        clear Q_range
        
    end % of ranges if statement   
end % of i loop

disp(' ')
disp(' ')

if tau_is_pos
    %Theoretical ranges for each shear range
    Q_store_test = log10(Q_star);
    t_store_test = log10(tau_star);

    p = polyfit(Q_store_test,t_store_test,1);

    q_test = linspace(-30,30,100);
    t_test = log10(tau_thresh);

    yp = polyval(p,q_test);

    for i = 1:length(tau_thresh)
        [Xo(i),Yo(i)] = mminvinterp(q_test,yp,t_test(i));
    end

    Xo = 10.^Xo;

    disp('<< Theoretical Functional Flow Ranges >>')
    for i = 1:n_ranges

        if i < n_ranges
            
            fprintf('For %g < T < %g, the theoretical functional flow range is %g < Q* < %g.',...
                tau_thresh(i+1),tau_thresh(i),Xo(i+1),Xo(i))
            fprintf('\n')
            fprintf('\n')

        else

            fprintf('For T < %g, the theoretical functional flow range is Q* < %g.',...
                tau_thresh(i),Xo(i))
            fprintf('\n')
            fprintf('\n')

        end % of ranges if statement

    end % of i loop
else
    disp(' ')
    disp('The functional flows model breaks down when t* becomes negative.')
    disp('Therefore, no theoretical flows can be obtained.')
    disp(' ')
    disp(' ')
end